﻿//////////////////////////////////////////////
// ProgramTrackersHolder.h
// 
//////////////////////////////////////////////

/// Defines / macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class AtmosphereLutProgramTracker ;
	class AtmosphereProgramTracker ;
	class BlurProgramsTracker ;
	class DofProgramsTracker ;
	class FilmGrainProgramTracker ;
	class FxaaProgramTracker ;
	class ImageEnvironmentProgramTracker ;
	class PbsProgramTracker ;
	class SsaoProgramTracker ;
	class TextureCopyProgramTracker ;
	class ToneMappingProgramTracker ;
}

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class ProgramTrackersHolder final
	{
		public :

			// Constructor, destructor
			ProgramTrackersHolder (nkGraphics::System* graphicsSystem) noexcept ;
			~ProgramTrackersHolder () ;

			// Getters
			AtmosphereLutProgramTracker* getAtmosphereLutProgramTracker () const ;
			AtmosphereProgramTracker* getAtmosphereProgramTracker () const ;
			BlurProgramsTracker* getBlurProgramsTracker () const ;
			DofProgramsTracker* getDofProgramsTracker () const ;
			FilmGrainProgramTracker* getFilmGrainProgramTracker () const ;
			FxaaProgramTracker* getFxaaProgramTracker () const ;
			ImageEnvironmentProgramTracker* getImageEnvironmentProgramTracker () const ;
			PbsProgramTracker* getPbsProgramTracker () const ;
			SsaoProgramTracker* getSsaoProgramTracker () const ;
			TextureCopyProgramTracker* getTextureCopyProgramTracker () const ;
			ToneMappingProgramTracker* getToneMappingProgramTracker () const ;

		private :

			// Functions
			ProgramTrackersHolder (const ProgramTrackersHolder&) = delete ;
			ProgramTrackersHolder (ProgramTrackersHolder&&) = delete ;

			// Operators
			ProgramTrackersHolder& operator= (const ProgramTrackersHolder&) = delete ;
			ProgramTrackersHolder& operator= (ProgramTrackersHolder&&) = delete ;

		private :

			// Attributes
			// Trackers we have
			nkMemory::UniquePtr<AtmosphereLutProgramTracker> _atmosphereLutProgramTracker ;
			nkMemory::UniquePtr<AtmosphereProgramTracker> _atmosphereProgramTracker ;
			nkMemory::UniquePtr<BlurProgramsTracker> _blurProgramsTracker ;
			nkMemory::UniquePtr<DofProgramsTracker> _dofProgramsTracker ;
			nkMemory::UniquePtr<FilmGrainProgramTracker> _filmGrainProgramTracker ;
			nkMemory::UniquePtr<FxaaProgramTracker> _fxaaProgramTracker ;
			nkMemory::UniquePtr<ImageEnvironmentProgramTracker> _imageEnvironmentProgramTracker ;
			nkMemory::UniquePtr<PbsProgramTracker> _pbsProgramTracker ;
			nkMemory::UniquePtr<SsaoProgramTracker> _ssaoProgramTracker ;
			nkMemory::UniquePtr<TextureCopyProgramTracker> _textureCopyProgramTracker ;
			nkMemory::UniquePtr<ToneMappingProgramTracker> _toneMappingProgramTracker ;
	} ;
}